function test_suite = testSin %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertEqual(sin(p),polysym.empty)

function testDefault
% Recall that the default value is 0.
p = polysym; 
assertEqual(sin(p),polysym(0))

function testScalar
polysyms('x')
p = sin(x);
assertEqual(p,polysym('sin(x)'))

function testVector
x = polysym('x',[1 2]);
p = sin(x);
assertEqual(p,polysym({'sin(x1)','sin(x2)'}))
